* This file calculates the supply of 10-year Treasury equivalents at market value 
* (denoted market10yeq in the code below) using the 
* CRSP Monthly Treasury Master File downloaded from WRDS, https://wrds.wharton.upenn.edu
* The data series for market10yeq is included in our stata data file

use c:\treas\crsp_bond_master.dta

ge year=year(qdate)
ge month=month(qdate)
ge day=day(qdate)
ge date=mdy(month,day,year)

ge matyear=year(idtmat)
ge matmonth=month(idtmat)
ge matday=day(idtmat)
ge matdate=mdy(matmonth,matday,matyear)

ge maturity=matdate-date
ge price=0.5*(abs(pric1r)+abs(pric2r)) if pcyld~=.
replace price=abs(pric1r) if pcyld~=. & pric2r==0
replace price=abs(pric2r) if pcyld~=. & pric1r==0

* Define the largest and smallest yield for the bond over the past 12 months
* Keep track of how many months ago it was

so crspid year month day
for num 0/12: ge yX=pcyld[_n-X] if crspid==crspid[_n-X]
gen maxy=max(y0,y1,y2,y3,y4,y5,y6,y7,y8,y9,y10,y11,y12) 
gen miny=min(y0,y1,y2,y3,y4,y5,y6,y7,y8,y9,y10,y11,y12) 
ge lagmax=.
ge lagmin=.
for num 0/12: replace lagmax=X if yX==maxy & lagmax==.
for num 0/12: replace lagmin=X if yX==miny & lagmin==.
ge order=1 if lagmax>lagmin & lagmax~=.
replace order=2 if lagmax<=lagmin & lagmin~=.

* Use the duration formula (dP/P)=-[D/(1+y)]*dy to estimate duration based on 
* the yield and price changes comparing these two months

ge dur=.
replace dur=-((price[_n-lagmin]-price[_n-lagmax])/price[_n-lagmax])*(1+pcyld[_n-lagmax])/(pcyld[_n-lagmin]-pcyld[_n-lagmax]) if crspid==crspid[_n-lagmax] & crspid==crspid[_n-lagmin] & order==1
replace dur=-((price[_n-lagmax]-price[_n-lagmin])/price[_n-lagmin])*(1+pcyld[_n-lagmin])/(pcyld[_n-lagmax]-pcyld[_n-lagmin]) if crspid==crspid[_n-lagmin] & crspid==crspid[_n-lagmin] & order==2

* Replace duration by remaining maturity if remaining maturity is less than two years (due to negative duration values from above approach)
ge durx=dur
replace durx=maturity/365 if maturity<2*365

* For first obs, replace duration by duration for next observation plus a month
replace durx=durx[_n+1]+1/12 if crspid~=crspid[_n-1] & crspid==crspid[_n+1]

* Replace duration by time to first call if first possible call is less than a year away and duration is negative
ge callyear=year(idtcp)
ge callmonth=month(idtcp)
ge callday=day(idtcp)
ge calldate=mdy(callmonth,callday,callyear)
ge callable=idtcp~=.
ge timetocall=calldate-date
replace durx=timetocall/365 if durx<=0  & callable==1

* Replace duration by remaining maturity if duration is still missing or negative
replace durx=maturity/365 if durx==. | durx<=0
egen x=sum(iout1r*(price/100)*(durx/10)) if maturity>=2*365, by(year month)
egen market10yeq=max(x), by(year month)
drop x

li market10yeq if month~=month[_n-1] & year==2008 & month==12
li market10yeq if month~=month[_n-1] & year==2009 & month==12
keep if (year<=1975 & month==6) | (year>=1976 & month==9)
so year month
drop if year==year[_n-1]
keep year market10yeq
drop if year>2008 

